////////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) since 1999. VASCO DATA SECURITY
// All rights reserved. http://www.vasco.com
//
////////////////////////////////////////////////////////////////////////////////

#import <Foundation/Foundation.h>

@protocol OrchestrationProtocol;

NS_ASSUME_NONNULL_BEGIN

/**
 * An implementation of a {@link UserAuthenticationInputDelegate} interface will be given by the Orchestration library
 * (See {@link com.vasco.orchestration.client.UserAuthenticationCallback#onUserAuthenticationRequired(UserAuthenticationInputDelegate)}).
*/
NS_REFINED_FOR_SWIFT
@protocol UserAuthenticationInputDelegate <NSObject>

/**
 * Need to be called to inform the Orchestration library of the user input.
 * The conformity of that input can be check by the Orchestration library.
 * That input can be used to encrypt the secret.
 * An error will be given if it is used for an UserAuthenticationTypeBiometric authentication.
 */
- (BOOL)onUserAuthenticationInputSuccessWithCharArrayInput:(const char *)input error:(NSError **)error;

/**
 * Need to be called to inform the Orchestration library of a successful user authentication.
 * An error will be given  if it is used for an UserAuthenticationTypePassword authentication.
 */
- (BOOL)onUserAuthenticationSuccessWithError:(NSError **)error;

/**
 * Need to be called to inform the Orchestration library of an aborted authentication flow.
 */
- (void)onUserAuthenticationAborted;

@optional
/**
 * Need to be called to inform the Orchestration library of the user input.
 * The conformity of that input can be check by the Orchestration library.
 * That input can be used to encrypt the secret.
 * Please note this will failed if it is used for UserAuthenticationTypeBiometric authentication.
 */

- (void)onUserAuthenticationInputSuccessWithCharArrayInput:(const char *)input DEPRECATED_MSG_ATTRIBUTE("This method has been renamed to -[UserAuthenticationInputDelegate onUserAuthenticationAborted:error:]") NS_SWIFT_UNAVAILABLE("Use method with error");

/**
 * Need to be called to inform the Orchestration library of an aborted authentication flow.
 */
- (void)onUserAuthenticationInputAborted DEPRECATED_MSG_ATTRIBUTE("This method has been renamed to -[UserAuthenticationInputDelegate onUserAuthenticationAborted]");

@end

NS_ASSUME_NONNULL_END
